﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Domaine;

namespace IHM
{
    public partial class DlgEmprunt : Form
    {
        public DlgEmprunt(List<Utilisateur> utils, List<Livre> livreEmprunter)
        {
            InitializeComponent();

            // Ajout de la liste des utilisateur à la liste déroulante
            cbxUtilisateurChoix.Items.AddRange(utils.ToArray<Utilisateur>());
            if (cbxUtilisateurChoix.Items.Count > 0)
            {
                // sélection du 1er élément de la liste
                cbxUtilisateurChoix.SelectedIndex = 0;
            }

            // Ajout de la liste des utilisateur à la liste déroulante
            cbxLivreChoix.Items.AddRange(livreEmprunter.ToArray<Livre>());
            if (cbxLivreChoix.Items.Count > 0)
            {
                // sélection du 1er élément de la liste
                cbxLivreChoix.SelectedIndex = 0;
            }
        }


        /// <summary>
        /// Renvoie l'utilisateur
        /// </summary>
        /// <returns></returns>
        public Utilisateur GetUtils()
        {
            return (Utilisateur) cbxUtilisateurChoix.SelectedItem;
        }

        /// <summary>
        /// Renvoie le livre
        /// </summary>
        /// <returns></returns>
        public Livre GetLivre()
        {
            return (Livre)cbxLivreChoix.SelectedItem;
        }
    }
}
